/*
   ######################################################################

   XBlast Robot.inc

   Character design tutorial part 1

   (C) by Mark Weyer

   ######################################################################
*/


//
///
//// Welcome to the tutorial. You will only need to read comments
//// that are indented like this one. The tutorial consists of
//// several parts that are sucessive approximations of a complete
//// character design.
///
//

//
///
//// The character of our tutorial is minimalistic,
//// because this is not meant as a PoVRay tutorial.
//// It is a stylized yellow/blue monowheel with green eyes.
///
//

// basic constants

#declare Wheel_diam = 2;
#declare Wheel_thickness = 1/2;
#declare Eye_size = 2/3;

// a macro for eyes

#macro eye(side)
  sphere {
    0 1/2
    pigment {	// this pigment partitions the eye into three layers:
		// black (pupil), green (iris), and white (rest)
      checker
      pigment {rgb <1,1,1>}
      pigment {
        checker
        pigment {rgb <0,1,0>}
        pigment {rgb <0,0,0>}
        translate <1/2,1/2,0>
        scale 10
        translate -z/4
      }
      translate <1/2,1/2,0>
      scale <10,10,1>
      translate -z/6
    }
    scale Eye_size
    translate <side*2/3,Wheel_diam,-1/2>
  }
#end

#macro wheel()
  torus {
    (Wheel_diam-Wheel_thickness)/2 Wheel_thickness/2
    rotate 90*z
    pigment {	// this pigment partitions the wheel in four sectors
      checker
      pigment {rgb <1,1,0>}
      pigment {rgb <0,0,1>}
      translate x/2
      scale 10
    }
    translate Wheel_diam/2*y
  }
#end

//
///
//// As follows, all we need to do is place our objects in the file.
//// This is most convenient in a union.
///
//

union {
  wheel()
  eye(1)
  eye(-1)

//
///
//// The following should be present in every character definition.
//// It handles the correct placement of the objects.
//// The objects should _prior_ to these adjustments be contained in a
////   box {<-2,0,-2> <2,4,2>}
//// and look in direction <0,0,-1>
///
//

  rotate playerAngle*y
  translate playerLocation
  translate -2*z
}

